/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.NetworkSimulationManager;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import DE.siemens.ad.pdraw.simulation.SimulationTool;

public class SimulateInOutNetworkAction
extends LogoToggleAction {
    private static final long serialVersionUID = 1L;

    public SimulateInOutNetworkAction() {
        this.putValue("Name", "SimulateInOutNetwork");
        this.putValue("textKey", "pdraw.app.createTools.addToNetwork");
        this.putValue("SmallIcon", Global.getIcon("Network.gif"));
    }

    public boolean doIt() {
        return this.doIt(Application.getInstance().getMdiManager().getActiveTopLevelView());
    }

    public boolean doIt(View updatedView) {
        SimulationTool tool = (SimulationTool)((LogoComfort)updatedView.getEditor()).tool();
        WiringDiagram wd = tool.getWiringDiagram();
        String ip = wd.getNetworkInfo().getIPAddress();
        SimulationManager srcSimulationManager = tool.getSimulationManager();
        SimulationManager tarSimulationManager = NetworkSimulationManager.getInstance().getSimulationManager(ip);
        if (ip.equals("")) {
            this.setEnabled(false);
            this.setSelected(false);
            this.putValue("defaultText", "IP address is not configured");
            this.putValue("textKey", "pdraw.app.createTools.ipNotSet");
            return true;
        }
        if (this.isSelected()) {
            this.setEnabled(true);
            if (this.checkDuplicatedIP(ip)) {
                this.putValue("defaultText", "Click to simulate in network");
                this.putValue("textKey", "pdraw.app.createTools.addToNetwork");
                return false;
            }
            this.putValue("defaultText", "Click to simulate out of network");
            this.putValue("textKey", "pdraw.app.createTools.removeFromNetwork");
            NetworkSimulationManager.getInstance().addSimulationManager(ip, srcSimulationManager);
        } else {
            this.setEnabled(true);
            this.putValue("defaultText", "Click to simulate in network");
            this.putValue("textKey", "pdraw.app.createTools.addToNetwork");
            if (tarSimulationManager == srcSimulationManager) {
                NetworkSimulationManager.getInstance().removeSimulationManager(ip);
            } else {
                return false;
            }
        }
        Application.getInstance().getMdiManager().updateSimulatedViewTitle(updatedView);
        return true;
    }

    private boolean checkDuplicatedIP(String ip) {
        SimulationManager simulationManager = NetworkSimulationManager.getInstance().getSimulationManager(ip);
        if (simulationManager != null) {
            Object[] additionalInformation = new Object[]{simulationManager.getEditor().getView().getModel().getFile().getName()};
            new LogoError(null, "pdraw.app.createTools.duplicateIP", "The IP address conflicts with another simulated network diagram: ", additionalInformation, 2, 0).display();
            return true;
        }
        return false;
    }
}

